﻿var widgetname = "RadioTuner";

function setup()
{
	try{
		if(window.widget)
		{
			var stationString = widget.preferenceForKey("radioStations");
			var stationName = "";
			var stationURL = "";
			var box = document.getElementById("stations");
			var boxIndex = 1;
			box.options[0] = new Option("Add Station", "");
			set_menu_text();
			box.selectedIndex = 0;
			while(stationString.length>3)
			{
				stationName = stationString.substring(0, stationString.indexOf(';'));
				stationString = stationString.substring(stationString.indexOf(';')+1);
				stationURL = stationString.substring(0, stationString.indexOf(';'));
				stationString = stationString.substring(stationString.indexOf(';')+1);
				box.options[boxIndex] = new Option(stationName, stationURL);
				boxIndex++;
			}
			widget.onhide = onhide;
    		widget.onshow = onshow;
		}
		check_plugin();
	}catch(error) {
		handle_error(error);
	}
}
function check_plugin()
{	
	var check = "";
 	for(i=0; i<navigator.plugins.length; i++)
 	{
 		if(navigator.plugins[i].name.substring(0,10) == "RealPlayer") 
 		{	
 			check = "ok";
 			i = navigator.plugins.length+1;
 		}
 	}
 	if(check = "") show_dialog();
}
function play()
{ 
	if( document.getElementById("stations").options.selectedIndex > 0 )
	{
		document.getElementById("playerdiv").style.display = "none";
		document.getElementById("controldiv").style.display = "none";
		document.getElementById("play_btn").style.display = "none";
		document.getElementById("pause_btn").style.display = "block";
		set_statusText('...', '#FFFFFF');
		
		change_station();
		
		document.getElementById("controldiv").style.display = "block";
	}
}

function pause()
{
	document.getElementById("playerdiv").style.display = "none";
	document.getElementById("controldiv").style.display = "none";
	if(document.getElementById("rp") != null)
	{
		document.getElementById("rp").DoStop();
	}
	set_statusText('', '#FFFFFF');
		
	document.getElementById("play_btn").style.display = "block";
	document.getElementById("pause_btn").style.display = "none";
}

function onhide()
{
	if( document.getElementById("play_btn").style.display == "block" ) 
	{
		document.getElementById("playerdiv").style.display = "none";
		document.getElementById("controldiv").style.display = "none";
	}
}

function onshow()
{
	if( document.getElementById("play_btn").style.display == "none" ) 
	{
		document.getElementById("playerdiv").style.display = "block";
	}	
	document.getElementById("controldiv").style.display = "block";
}

function OnBuffering(flags, percent_complete)
{
	if(flags==2) set_statusText("buffering: "+percent_complete+"%", "#FFDB00");
	else set_statusText("buffering: "+percent_complete+"%", "#FFFFFF");
}

function OnPlayStateChange()
{
	
	var state = document.getElementById("rp").GetPlayState();	
	var status = "";
	
	switch(state)
	{
		case 0: 
		{
			status = "stopped"; break;
			document.getElementById("play_btn").style.display = "block";
			document.getElementById("pause_btn").style.display = "none";
		}
		case 1: 
		{
			check_status();
			status = "contacting"; break;
		}
		case 2: 
		{
			check_status();
			status = "buffering"; break;
		}
		case 3: 
		{
			check_status();
			break;
		}
		case 4: 
		{
			check_status();
			break;
		}
		case 5: 
		{
			check_status();
			status = "seeking"; 
			break;
		}
		default: status = "";
	}
	set_statusText(status, "#FFFFFF");
}
function check_status()
{
	if(document.getElementById("play_btn").style.display == "block")
	{
		document.getElementById("rp").DoStop();
	}
}

function OnErrorMessage(severity, rma_code, user_code, user_string, more_info_url, error)
{
	document.getElementById("play_btn").style.display = "block";
	document.getElementById("pause_btn").style.display = "none";
	
	error = error.substring(0, 25);
	if(severity < 6) set_statusText(error, "#FF0000");
	else set_statusText(error, "#FFFFFF");
	handle_error(error);
}

function set_statusText(text, color)
{
	document.getElementById("statusText").style.color = color;
	document.getElementById("statusText").innerText = text;
}

function i_click()
{
	try{
		if(document.getElementById("addPanel").style.display != "none")
			show_addPanel(-80);
		else
			show_addPanel(80);
	}catch(error) {
		handle_error(error);
	}
}

function show_addPanel(height)
{	
	try{
		if(height<0 && document.getElementById("addPanel").style.display != "none") 
		{
			document.getElementById("addPanel").style.display = "none";
			window.resizeBy(0, height);
			
			document.getElementById("background").src = "Images/Default.png";
		}
		else 
		{
			if(document.getElementById("addPanel").style.display != "block")
			{
				document.getElementById("addPanel").style.display = "block";
				window.resizeBy(0, height);
				
				if(document.getElementById("stations").options.selectedIndex != 0) edit_station();
				else add_station();
				
				document.getElementById("background").src = "Images/Default_prefs.png";
			}
		}
	}catch(error) {
		handle_error(error);
	}
}

function add_new_station()
{	
	try{
		var box = document.getElementById("stations");
		var index = box.options.selectedIndex;
		
		if(document.getElementById("button_add_new").value == "Save")
		{
			box.options[box.options.selectedIndex] = new Option(document.getElementById("text_name").value, document.getElementById("text_url").value);
			box.options.selectedIndex = index;
		}
		else
		{
			box.options[box.options.length] = new Option(document.getElementById("text_name").value, document.getElementById("text_url").value);
			box.options.selectedIndex = box.options.length-1;
		}
		edit_station();
		save_stations();
	}catch(error) {
		handle_error(error);
		}
}

function add_station()
{
	try{
		document.getElementById("button_add_new").value = "Add";
		document.getElementById("button_delete").disabled = true;
		
		document.getElementById("text_name").value = "Station Name";
		document.getElementById("text_url").value = "Station URL";
		
		set_menu_text();
	}catch(error) {
		handle_error(error);
	}
}

function set_menu_text()
{
	try{
		document.getElementById("popupMenuText").innerText 
			= document.getElementById("stations").options[document.getElementById("stations").options.selectedIndex].text;
	}catch(error) {
		handle_error(error);
	}
}

function box_change()
{
	try{
		if(document.getElementById("addPanel").style.display != "block")
		{
			if(document.getElementById("stations").options.selectedIndex == 0) 
			{	
				show_addPanel(80);
				pause();
			}
			else 
			{
				if(document.getElementById("play_btn").style.display == "none")
				{
					play();
				}
				else pause();
			}
		}
		else
		{  
			if(document.getElementById("stations").options.selectedIndex != 0) 
			{
				edit_station();
				if(document.getElementById("play_btn").style.display == "none")
				{
					play();
				}
				else pause();
			}
			else 
			{
				add_station();
				pause();
			}
		}
		set_menu_text();
	}catch(error) {
		handle_error(error);
	}
}

function edit_station()
{
	try{
		var box = document.getElementById("stations");	
		if(box.options.selectedIndex > 0) 
		{
			if(document.getElementById("addPanel").style.display != "block")
			{
				show_addPanel(80);
			}
			document.getElementById("text_name").value = box.options[box.selectedIndex].text;
			document.getElementById("text_url").value = box.options[box.selectedIndex].value;
			
			document.getElementById("button_add_new").value = "Save";
			document.getElementById("button_delete").disabled = false;
		}
		set_menu_text();
	}catch(error) {
		handle_error(error);
	}
}


function change_station()
{
	document.getElementById("controldiv").style.display = "none";
	document.getElementById("playerdiv").style.display = "none";
	try{
		var box = document.getElementById("stations");
		var newURL = "";
		if(box.selectedIndex>0)
		{
			newURL = box.options[box.selectedIndex].value;
			var rp_control = document.getElementById("playerdiv");
			rp_control.style.display = "block";
			rp_control.innerHTML = '<embed type="audio/x-pn-realaudio-plugin" src="'+newURL+'" pluginspage="" width="0" height="0" nojava="true" id="rp" console="player" scriptcallbacks="OnBuffering(), OnPlayStateChange(), OnErrorMessage()"  />';
		
			document.getElementById("controldiv").style.display = "block";
		}
	}catch(error) {
		handle_error(error);
	}
}

function save_stations()
{
	try{
		var stationString = "";
		var stationList = document.getElementById("stations").options;
		for(i=1; i<stationList.length; i++)
		{
			stationString = stationString+stationList[i].text+";"+stationList[i].value+";";
		}
		if(window.widget)
		{
			widget.setPreferenceForKey(stationString, "radioStations");
		}
	}catch(error) {
		handle_error(error);
	}
}

function remove_station()
{
	try{
		var box = document.getElementById("stations");
		
		if(box.selectedIndex!=0)
		{
			for(i=box.selectedIndex; i<box.options.length-1; i++)
			{
				box.options[i] = new Option(box.options[i+1].text, box.options[i+1].value);
			}
			box.options.length--;
			box.selectedIndex = 0;
			set_menu_text();
			
			save_stations();
			add_station();
			change_station();
		}
	}catch(error) {
		handle_error(error);
	}
}


function openWeb(url){
	try{
		if(window.widget){
			widget.openURL(url);
		}
	}catch(error) {
		handle_error(error);
	}
}

function handle_error(error)
{
	set_statusText('An error occured...', '#FF0000');
	alert(widgetname+': \n       '+error);
}

function show_dialog()
{
	document.getElementById("dialog").style.display = "block";
}

function hide_dialog()
{
	document.getElementById("dialog").style.display = "none";	
	openWeb('http://www.real.com');
}
