/*
	RadioTuner
	http://radiotuner.wuersch.net
	© Copyright 2006 Markus Wuersch. All rights reserved.
*/

var widgetname = "RadioTuner";
var button_value = "Save";

var check_rp = "no";
var check_wm = "no";

var i_count = 0;
var i_change = 1;

var volume = 50;
var vol_slider;

var http;
var textcolor = "#FFFFFF";

var http;
var vhttp;

function setup()
{
	var prefs = 2;
	try{
		if(window.widget)
		{
			button_value = "Save";
			
			check_rp = "no";
			check_wm = "no";

			var stationString = widget.preferenceForKey("radioStations2");
			if(stationString == null) 
			{
				prefs = 1;
				stationString = widget.preferenceForKey('radioStations');
			}
			if(stationString == null) stationString = " ";
			
			var stationName = "";
			var stationURL = "";
			var box = document.getElementById("stations");
			var boxIndex = 1;
			box.options[0] = new Option(getLocalizedString("Add Station"), "");
			set_menu_text();
			box.selectedIndex = 0;
		
			if(prefs==1) {
				while(stationString.length>3)
				{
					stationName = stationString.substring(0, stationString.indexOf(';'));
					stationString = stationString.substring(stationString.indexOf(';')+1);
					stationURL = stationString.substring(0, stationString.indexOf(';'));
					stationString = stationString.substring(stationString.indexOf(';')+1);
					box.options[boxIndex] = new Option(stationName, '1'+stationURL);
					boxIndex++;
				}
			}
			else {
				while(stationString.length>3)
				{
					stationName = stationString.substring(0, stationString.indexOf(';'));
					stationString = stationString.substring(stationString.indexOf(';')+1);
					stationURL = stationString.substring(0, stationString.indexOf(';'));
					stationString = stationString.substring(stationString.indexOf(';')+1);
					box.options[boxIndex] = new Option(stationName, stationURL);
					boxIndex++;
				}
			}
			save_stations();	// save the stations so that they get sorted
			
			document.getElementById("button_delete").value = getLocalizedString("Delete");
			
			document.getElementById("volume_slider").style.display = "block";
			document.getElementById("addpanel").style.display = "none";
			document.getElementById("back").style.display = "none";
			document.getElementById("messageBox").style.display = "none";
			document.getElementById("messageCover").style.display = "none";
			document.getElementById("updateDialog").style.display = "none";
			
			document.getElementById("dialog_f4m").style.display = "none";
			document.getElementById("dialog_rp").style.display = "none";
			document.getElementById("dialog_reload").style.display = "none";
			
			document.getElementById("backImage").src = "Images/"+document.getElementById("bcolor").value;
			document.getElementById("backBackImage").src = "Images/back_"+document.getElementById("bcolor").value;
			
			document.getElementById("flipblack").style.display = "none";
			document.getElementById("flip").style.display = "block";
			
			vol_slider = new AppleHorizontalSlider(document.getElementById("volume_slider"), sliderChanged);
			vol_slider.setValue(1);
			
			var find = getLocalizedString('FIND');
			var share = getLocalizedString('SHARE');
			document.getElementById("weblink").innerHTML = 
				"<a href=\"javascript:openWeb('http://radiotuner.wuersch.net/stations.php')\">"+
					find+"</a> "+getLocalizedString(' or ')+"<a href=\"javascript:openWeb('http://radiotuner.wuersch.net/share.php')\">"+share+"</a>";
			
			check_plugin();
					
			widget.onhide = onhide;
    		widget.onshow = onshow;
			setTimeout("checkUpdates()", 0);
    		alert(widgetname+' ok');
		}
		else
		{	
			alert('RadioTuner is a widget for Mac OS X Dashboard only.');
		}
	}catch(error) {
		handle_error("setup(): "+error);
	}
}


function check_plugin()
{	
 	for(i=0; i<navigator.plugins.length; i++)
 	{
 		if(navigator.plugins[i].name.substring(0,17) == "RealPlayer Plugin") 
 		{	
 			check_rp = "ok";
 		}
		if(navigator.plugins[i].name.substring(0,26) == "Flip4Mac Windows Media Web") 
 		{	
 			check_wm = "ok";
 		}
 	}
 	if(check_wm == "no") { show_dialog('f4m'); }
 	if(check_rp == "no") { show_dialog('rp'); }
}
function play()
{
	if( document.getElementById("stations").options.selectedIndex > 0 )
	{	set_statusText('...', '#FFFFFF');
		document.getElementById("playerdiv").style.display = "none";
		document.getElementById("play_btn").style.display = "none";
		document.getElementById("pause_btn").style.display = "block";
		set_statusText('...', '#FFFFFF');
		
		change_station();
		set_volume(0);
	}
}

function pause()
{
	document.getElementById("playerdiv").style.display = "none";
	set_statusText('', '#FFFFFF');
		
	document.getElementById("play_btn").style.display = "block";
	document.getElementById("pause_btn").style.display = "none";
}

function onhide()
{
	if( document.getElementById("play_btn").style.display == "block" ) 
	{
		document.getElementById("playerdiv").innerHTML = "";
		document.getElementById("playerdiv").style.display = "none";
	}
}

function onshow()
{
	if( document.getElementById("play_btn").style.display == "none" ) 
	{
		document.getElementById("playerdiv").style.display = "block";
	}	
}

function OnBuffering(flags, percent_complete)
{
	//if(flags==2) set_statusText(""+percent_complete+"%", "#FFDB00");
	//else set_statusText(""+percent_complete+"%", textcolor);
	set_statusText(""+percent_complete+"%", textcolor);
}

function OnPlayStateChange()
{
	{
		var state = "";
		var status = "";
		
		switch(state)
		{
			case 0: 
			{
				status = "stopped"; break;
				document.getElementById("play_btn").style.display = "block";
				document.getElementById("pause_btn").style.display = "none";
			}
			case 1: 
			{
				//check_status();
				status = "contacting"; break;
			}
			case 2: 
			{
				//check_status();
				status = "buffering"; break;
			}
			case 3: 
			{
				//check_status();
				break;
			}
			case 4: 
			{
				//check_status();
				break;
			}
			case 5: 
			{
				//check_status();
				status = "seeking"; 
				break;
			}
			default: status = "";
		}
	}
	set_statusText(status, textcolor);
}

function OnErrorMessage(severity, rma_code, user_code, user_string, more_info_url, error)
{
	document.getElementById("play_btn").style.display = "block";
	document.getElementById("pause_btn").style.display = "none";
	
	error = error.substring(0, 25);
	if(severity < 6) set_statusText(error, "#FF0000");
	else set_statusText(error, textcolor);
	handle_error(error);
}

function set_statusText(text, color)
{
	document.getElementById("statusText").style.color = color;
	document.getElementById("statusText").innerText = text;
}

function showAddPanel()
{
	try{
		if(document.getElementById("addpanel").style.display != "none")
			show_addpanel(-100);
		else
			show_addpanel(100);
	}catch(error) {
		handle_error("showAddPanel(): "+error);
	}
}

function show_addpanel(height)
{	
	try{
		if(height<0 && document.getElementById("addpanel").style.display != "none") 
		{
			document.getElementById("addpanel").style.display = "none";
			window.resizeBy(0, height);
		}
		else 
		{
			if(document.getElementById("addpanel").style.display != "block")
			{
				document.getElementById("addpanel").style.display = "block";
				window.resizeBy(0, height);
				
				if(document.getElementById("stations").options.selectedIndex != 0) edit_station();
				else add_station();
			}
		}
	}catch(error) {
		handle_error("show_addpanel(): "+error);
	}
}

function add_new_station()
{	
	try{
		var box = document.getElementById("stations");
		var index = box.options.selectedIndex;

		if(button_value == "Save")
		{
			box.options[box.options.selectedIndex] = new Option(document.getElementById("text_name").value, ''+document.getElementById("pl_type").options.selectedIndex+document.getElementById("text_url").value);
			box.options.selectedIndex = index;
		}
		else
		{
			box.options[box.options.length] = new Option(document.getElementById("text_name").value, ''+document.getElementById("pl_type").options.selectedIndex+document.getElementById("text_url").value);
			box.options.selectedIndex = box.options.length-1;
		}
		document.getElementById("text_url").style.color = "black";
		document.getElementById("text_name").style.color = "black";
		
		edit_station();
		save_stations();
	}catch(error) {
		handle_error("add_new_station(): "+error);
	}
}

function add_station()
{
	try{
		document.getElementById("button_add_new").value = getLocalizedString("Add");
		document.getElementById("button_delete").disabled = true;
		button_value = "Add";
		
		document.getElementById("text_name").value = getLocalizedString("Station Name");
		document.getElementById("text_url").value = getLocalizedString("Link to Live Stream");
		
		document.getElementById("pl_type").options.selectedIndex = 0;
		
		set_menu_text();
	}catch(error) {
		handle_error("add_station(): "+error);
	}
}

function set_menu_text()
{
	try{
		document.getElementById("popupMenuText").innerText 
			= document.getElementById("stations").options[document.getElementById("stations").options.selectedIndex].text;
	}catch(error) {
		handle_error("set_menu_text(): "+error);
	}
}

function box_change()
{
	try{
	
		document.getElementById("text_url").style.color = "black";
		document.getElementById("text_name").style.color = "black";
		
		if(document.getElementById("addpanel").style.display != "block")
		{
			if(document.getElementById("stations").options.selectedIndex == 0) 
			{	
				show_addpanel(100);
				pause();
			}
			else 
			{
				if(document.getElementById("play_btn").style.display == "none")
				{
					play();
				}
				else pause();
			}
		}
		else
		{  
			if(document.getElementById("stations").options.selectedIndex != 0) 
			{
				edit_station();
				if(document.getElementById("play_btn").style.display == "none")
				{
					play();
				}
				else pause();
			}
			else 
			{
				add_station();
				pause();
			}
		}
		set_menu_text();
	}catch(error) {
		handle_error("box_change(): "+error);
	}
}

function edit_station()
{
	try{
		var box = document.getElementById("stations");	
		if(box.options.selectedIndex > 0) 
		{
			if(document.getElementById("addpanel").style.display != "block")
			{
				show_addpanel(100);
			}
			document.getElementById("text_name").value = box.options[box.selectedIndex].text;
			document.getElementById("text_url").value = box.options[box.selectedIndex].value.substr(1, box.options[box.selectedIndex].value.length-1);
			
			document.getElementById("pl_type").options.selectedIndex = box.options[box.selectedIndex].value.substr(0,1);
			
			document.getElementById("button_add_new").value = getLocalizedString("Save");
			button_value = "Save";
			document.getElementById("button_delete").disabled = false;
		}
		set_menu_text();
	}catch(error) {
		handle_error("edit_station(): "+error);
	}
}


function change_station()
{
	document.getElementById("playerdiv").style.display = "none";
	try{
		var box = document.getElementById("stations");
		var newURL = "";
		var type = "";
		if(box.selectedIndex>0)
		{
			newURL = box.options[box.selectedIndex].value;
			type = newURL.substr(0,1);
			document.getElementById("pl_type").options.selectedIndex = type;
			newURL = newURL.substr(1, newURL.length-1);
			var rp_control = document.getElementById("playerdiv");
			rp_control.innerHTML = "";
			
			rp_control.style.display = "block";
			
			type = get_player_type();
			if(type=="audio/x-pn-realaudio-plugin") 
			{
				set_statusText('...', '#FFFFFF');
				rp_control.innerHTML = '<embed id="mp" src="'+newURL+'" filename="'+newURL+'" type="'+type+'" width="69" height="23" transparentatstart="0" autostart="1" animationatstart="0" showcontrols="true" showaudiocontrols="1" showpositioncontrols="0" autosize="0" showstatusbar="0" displaysize="false"          nojava="true" controls="volumeslider" scriptcallbacks="OnBuffering(), OnPlayStateChange(), OnErrorMessage()"       autoplay="true" bgcolor="BLACK" EnableJavaSript="true"/>';
				set_statusText('', '#FFFFFF');
			}
			else 
			{
				set_statusText('...', '#FFFFFF');
				rp_control.innerHTML = '<embed src="foo.mov" qtsrc="'+newURL+'" width="69" height="23" name="mp" id="mp" enablejavascript="true"> </embed>'
				set_statusText('', '#FFFFFF');
			}
		}
	}catch(error) {
		handle_error("change_station(): "+error);
	}
}

function get_player_type() 
{	
	try{
		return document.getElementById("pl_type").options[document.getElementById("pl_type").options.selectedIndex].value;
	}catch(error) {
		handle_error("get_player_type(): "+error);
	}
}

function pl_type_change() 
{
	try{
		if(document.getElementById("pl_type").options.selectedIndex==0 && check_rp=='no') show_dialog('rp');
		if(document.getElementById("pl_type").options.selectedIndex==1 && check_wm=='no') show_dialog('f4m');
		
		if( document.getElementById("stations").options.selectedIndex>0 ) add_new_station();
		
		if(document.getElementById("playerdiv").style.display == "block") 
		{
			change_station();
		}
	}catch(error) {
		handle_error("pl_type_change(): "+error);
	}
}

function save_stations()
{
	try{
		sort_stations();
	
		var stationString = "";
		var stationList = document.getElementById("stations").options;
		for(i=1; i<stationList.length; i++)
		{
			stationString = stationString+stationList[i].text+";"+stationList[i].value+";";
		}
		if(window.widget)
		{
			widget.setPreferenceForKey(stationString, "radioStations2");
		}
	}catch(error) {
		handle_error("save_station(): "+error);
	}
}

function remove_station()
{
	try{
		var box = document.getElementById("stations");

		if(box.selectedIndex!=0)
		{
			for(i=box.selectedIndex; i<box.options.length-1; i++)
			{
				box.options[i] = new Option(box.options[i+1].text, box.options[i+1].value);
			}
			box.options.length--;
			box.selectedIndex = 0;
			
			set_menu_text();
			
			save_stations();
			add_station();
			change_station();
		}
	}catch(error) {
		handle_error("remove_station(): "+error);
	}
}



function sort_stations()
{
	try{
		var box = document.getElementById("stations");
		var selText = box.options[box.selectedIndex].text;
		var selValue = box.options[box.selectedIndex].value;
		
		var list = new Array(box.options.length-1);
		var st = null;
		
		for(i=1; i<box.options.length; i++) 
		{
			st = new Array(2);
			st[0] = box.options[i].text;
			st[1] = box.options[i].value;
			list[i-1] = st;
		}
		
		if(list.length>2) 
		{
			for( i=1; i<list.length; i++)
			{
				var j = i;
				var B = list[i][0];
				var BArray = list[i];
				
				while( (j>0) && (list[j-1][0].toUpperCase()>B.toUpperCase()) )
				{
					list[j] = list[j-1];
					j--;
				}
				
				list[j] = BArray;
			}
			
			for(i=1; i<box.options.length; i++)
			{
				box.options[i].text = list[i-1][0];
				box.options[i].value = list[i-1][1];
				
				if( selText==list[i-1][0] && selValue==list[i-1][1] ) 
				{
					box.selectedIndex = i;
				}
				
			}
		}
    }catch(error) {
		handle_error("sort_stations(): "+error);
	}
}


function openWeb(url){
	try{
		if(window.widget){
			widget.openURL(url);
		}
	}catch(error) {
		handle_error("openWeb(): "+error);
	}
}

function handle_error(error)
{
	set_statusText('Error...', '#FF0000');
	alert('***** RadioTuner Error *****');
	alert(error);
	try
	{
		var exp = error.javaException;
		if(exp!=null) alert(error.printStackTrace());
	}catch(e) { }
	alert('****************************');
}

function show_dialog(player)
{
	document.getElementById("messageCover").style.display = "block";
	if(player=='rp') document.getElementById("dialog_rp").style.display = "block";
	if(player=='f4m') document.getElementById("dialog_f4m").style.display = "block";
	if(player=='reload') document.getElementById("dialog_reload").style.display = "block";
	
	if(player=='all') {
		document.getElementById("dialog_rp").style.display = "block";
		document.getElementById("dialog_f4m").style.display = "block";
	}
}

function hide_dialog(player)
{
	if(player=='reload') {
		document.getElementById("dialog_reload").style.display = "none";
	}
	else {
		show_dialog('reload');
		if(player=='rp') {
			document.getElementById("dialog_rp").style.display = "none";	
			openWeb('http://www.real.com');
		}
		else 
		{
			if(player=='f4m') {
				document.getElementById("dialog_f4m").style.display = "none";	
				openWeb('http://www.microsoft.com/windows/windowsmedia/player/wmcomponents.mspx');
			}
		}
	}
	
	hide_messageCover();
}

function getLocalizedString (key)
{
    try {
        var ret = localizedStrings[key];
        if (ret === undefined)
            ret = key;
        return ret;
    } catch (ex) {}
 
    return key;
}

function set_volume(change)
{
	try
	{
		var player = document.getElementById("mp");
		if(player!=null)
		{
			volume = volume+change;
			if(volume>100) volume = 100;
			if(volume<0) volume = 0;
			if(get_player_type()!="audio/x-pn-realaudio-plugin") 
			{
				player.SetVolume(parseInt(volume*2.55));
			}
			else
			{
				player.SetVolume(volume);
			}
		}
	}catch(error) {
		//handle_error("set_volumen(): "+error);
	}
}

function sliderChanged(currentValue)
{
	try
	{
		var player = document.getElementById("mp");
		if(player!=null)
		{
			if(get_player_type()!="audio/x-pn-realaudio-plugin") 
			{
				document.getElementById("mp").SetVolume(parseInt(currentValue*255));
			}
			else
			{
				document.getElementById("mp").SetVolume(parseInt(currentValue*100));
			}
		}
		volume = parseInt(currentValue*100);
	}catch(error) {
		handle_error("sliderChanged(): "+error);
	}
}


function url_change()
{
	document.getElementById("text_url").style.color = "red";
}
function name_change()
{
	document.getElementById("text_name").style.color = "red";
}


function textcolor_changed()
{
	if(document.getElementById("tcolor").selectedIndex == 0) 
	{
		textcolor = "black";
		document.getElementById("flip").style.display = "none";
		document.getElementById("fliprollie").style.display = "none";
		document.getElementById("flipblack").style.display = "block";
		document.getElementById("fliprollieblack").style.display = "block";
	}
	else 
	{
		textcolor = "white";
		document.getElementById("flip").style.display = "block";
		document.getElementById("fliprollie").style.display = "block";
		document.getElementById("flipblack").style.display = "none";
		document.getElementById("fliprollieblack").style.display = "none";
	}
	
	this.document.getElementById("popupMenuText").style.color = textcolor;
	this.document.getElementById("statusText").style.color = textcolor;
	this.document.getElementById("tcolorText").style.color = textcolor;
	this.document.getElementById("bcolorText").style.color = textcolor;
	document.getElementById("arrows_image").src = "Images/"+document.getElementById("tcolor").value;
}
function backcolor_changed()
{
	document.getElementById("backImage").src = "Images/"+document.getElementById("bcolor").value;
	document.getElementById("backBackImage").src = "Images/back_"+document.getElementById("bcolor").value;
}






function findRadioURL() 
{
	try
	{
		if( document.getElementById("text_url").value.substring(0,7)=="http://" || document.getElementById("text_url").value.substring(0,4)=="www." )
		{
			document.getElementById("messageCover").style.display = "block";
			http = getHTTPObject();
			http.open("GET", document.getElementById("text_url").value, true);
			http.onreadystatechange = handleHttpResponse;
			http.send(null);
		}
		else
		{
			show_messageBox('URL is not an http link.');
		}
	}catch(error) {
		handle_error("findRadioURL(): "+error);
		hide_messageCover();
	}
 }

function getHTTPObject() 
{
	try
	{
		 var xmlhttp;
		 if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
		   try {
		     xmlhttp = new XMLHttpRequest();
		   } catch (e) {
		     xmlhttp = false;
		   }
		 }
	 	return xmlhttp;
	}catch(error) {
		handle_error("getHTTPObject(): "+error);
		hide_messageCover();
	}
}


function handleHttpResponse() 
{
	try
	{
		var index = 1;
		var count = 0;
		var plType = "";
		if (http.readyState == 4) 
		{
		  	var xml = http.responseText;

		  	if(xml != null)
		  	{
			   	var temp;
			   	var found = 0;

			   	while(found==0 && index > 0 && count<100)
			   	{
			   		count++;
			   		
			   		index = xml.indexOf('<embed');
			   		if(index==-1) index = xml.indexOf('<EMBED');
				   	if(index>-1)
				   	{
				   		xml = xml.substring(index);

				   		plType = getPlayerType(xml);
		
				   		if(plType!="")
				   		{
				   			found = 1;
					   		if(plType=='rp') document.getElementById("pl_type").selectedIndex = 0;
					   		else 
					   		{
					   			if(plType=='wm') document.getElementById("pl_type").selectedIndex = 1;
					   		}
					   		
					   		temp = getPlayerSource(xml), '<embed';
					   		document.getElementById("text_url").value = temp;
					   		show_messageBox('Success!');
				   		}
						else 
						{
							xml = xml.substring(5); // just so the embed tag is gone.
						}
				   	}
				   	else
				   	{
				   		index = xml.indexOf('<object');
				   		if(index==-1) index = xml.indexOf('<OBJECT');
					   	if(index>-1)
					   	{
					   		xml = xml.substring(index);
					   		
					   		plType = getPlayerType(xml);
					   		if(plType!="")
					   		{
					   			found = 1;
						   		if(plType=='rp') document.getElementById("pl_type").selectedIndex = 0;
						   		else 
						   		{
						   			if(plType=='wm') document.getElementById("pl_type").selectedIndex = 1;
						   		}
						   		
						   		temp = getPlayerSource(xml, 'object');
						   		document.getElementById("text_url").value = temp;
						   		show_messageBox('Success!');
					   		}
					   	}
				   	}
			   	}
			   	if(count>99) handle_error("handleHttpResponse... findRadioURL(): loop terminated by ''count'");
		  	}
		  	if(found==0)
		  	{
		  		show_messageBox('Could not find player <br/>on page.');
		  		http = null;
		  	}
		}
		hide_messageCover();
	}catch(error) {
		handle_error("handleHttpResponse(): "+error);
		http = null;
		hide_messageCover();
	}
}

function getPlayerType(xmlString)
{
	var temp = xmlString;
	var i = temp.indexOf('type');
	var j = -1;
	if(i==-1) i = temp.indexOf('TYPE');
	if(i>-1)
	{
		temp = temp.substring(i);
		temp = temp.substring(temp.indexOf('=')+1);
		//temp = temp.substring(0, temp.indexOf('"'));
		
		if(temp.indexOf('mplayer')>-1) return 'wm';
		if(temp.indexOf('real')>-1) return 'rp';
		return "";
	}
	else
	{
		return "";
	}
}
function getPlayerSource(xmlString)
{
	var temp = xmlString;
	var i = temp.indexOf('src');
	if(i==-1) i = temp.indexOf('SRC');
	if(i==-1) i = temp.indexOf('data');
	if(i==-1) i = temp.indexOf('DATA');

	if(i>-1)
	{
		temp = temp.substring(i);
		temp = temp.substring(temp.indexOf('"')+1);
		temp = temp.substring(0, temp.indexOf('"'));
		
		return temp;
	}
	else
	{
		return "";
	}
}
 
 function checkUpdates()
 {
	vhttp = getHTTPObject();
	vhttp.open("GET", "http://radiobeta.wuersch.net/ws/version.php", true);
	vhttp.onreadystatechange = handlevHttpResponse;
	vhttp.send(null);
 }
 function handlevHttpResponse()
 {
	try{
		var xml = vhttp.responseText;
		//alert(xml);
		if( vhttp != null && xml != null && xml.length < 7) {
			var version = parseFloat(xml);
			if( version>2.0 )
			{
				document.getElementById("updateDialog").style.display = "block";
				document.getElementById("messageCover").style.display = "block";
				alert('found new update');
			}
			else
			{
				alert('no update found.');
			}
			setTimeout("checkUpdates()", 600000000);	// about 7 days
		}
	}catch(error) {
		handle_error("handlevHttpResponse(): "+error);
		vhttp = null;
		hide_messageCover();
	}
 }
 
 
 function hide_messageBox()
 {
 	document.getElementById("messageBox").style.display = "none";
	hide_messageCover();
 }

 function show_messageBox(messageText)
 {
 	document.getElementById("messageText").innerHTML = messageText;
	document.getElementById("messageBox").style.display = "block";
	document.getElementById("messageCover").style.display = "block";
 }
 
 function hide_updateDialog()
 {
 	document.getElementById("updateDialog").style.display = "none";
	hide_messageCover();
 }
 
 function play_btn_down()
 {
 	document.getElementById("play_btn_image").src = "Images/play_btn_down.png";
 }
 function play_btn_up()
 {
 	document.getElementById("play_btn_image").src = "Images/play_btn.png";
 }
 function pause_btn_down()
 {
 	document.getElementById("pause_btn_image").src = "Images/pause_btn_down.png";
 }
 function pause_btn_up()
 {
 	document.getElementById("pause_btn_image").src = "Images/pause_btn.png";
 }
 function small_btn_down()
 {
 	if( document.getElementById("addpanel").style.display == "none") 
 		document.getElementById("smallbtn_image").src = "Images/smallbtn_up_d.png";
 	else
 		document.getElementById("smallbtn_image").src = "Images/smallbtn_down_d.png";
 }
 function small_btn_up()
 {
 	if( document.getElementById("addpanel").style.display == "none") 
 		document.getElementById("smallbtn_image").src = "Images/smallbtn_up.png";
 	else
 		document.getElementById("smallbtn_image").src = "Images/smallbtn_down.png";
 }
 
 
 function hide_messageCover()
 {
//	alert("f4m: "+document.getElementById("dialog_f4m").style.display);
//	alert("rp: "+document.getElementById("dialog_rp").style.display);
//	alert("reload: "+document.getElementById("dialog_reload").style.display);
	
	if( document.getElementById("dialog_f4m").style.display == "none"
			&& document.getElementById("dialog_rp").style.display == "none"
			&& document.getElementById("dialog_reload").style.display == "none" )
		document.getElementById("messageCover").style.display = "none";
 }

