/*

Copyright _ 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.

*/


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event)
{
	try{
		if (!flipShown)			// if the preferences flipper is not already showing...
		{
			if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
			{
				clearInterval (animation.timer);
				animation.timer  = null;
			}
			
			var starttime = (new Date).getTime() - 13; 		// set it back one frame
			
			animation.duration = 500;												// animation time, in ms
			animation.starttime = starttime;					
			if(document.getElementById ('flip').style.display == 'block' )					// specify the start time
			{ animation.firstElement = document.getElementById ('flip'); }		// specify the element to fade
			else { animation.firstElement = document.getElementById ('flipblack'); }
			animation.timer = setInterval ("animate();", 13);						// set the animation function
			animation.from = animation.now;											// beginning opacity (not ness. 0)
			animation.to = 1.0;														// final opacity
			animate();																// begin animation
			flipShown = true;														// mark the flipper as animated
		}
	}catch(error) {
		handle_error(error);
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event)
{
	try{
		if (flipShown)
		{
			// fade in the flip widget
			if (animation.timer != null)
			{
				clearInterval (animation.timer);
				animation.timer  = null;
			}
			
			var starttime = (new Date).getTime() - 13;
			
			animation.duration = 500;
			animation.starttime = starttime;
			if(document.getElementById ('flip').style.display == 'block' )					// specify the start time
			{ animation.firstElement = document.getElementById ('flip'); }		// specify the element to fade
			else { animation.firstElement = document.getElementById ('flipblack'); }
			animation.timer = setInterval ("animate();", 13);
			animation.from = animation.now;
			animation.to = 0.0;
			animate();
			flipShown = false;
		}
	}catch(error) {
		handle_error(error);
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	try{
		var T;
		var ease;
		var time = (new Date).getTime();
			
		
		T = limit_3(time-animation.starttime, 0, animation.duration);
		
		if (T >= animation.duration)
		{
			clearInterval (animation.timer);
			animation.timer = null;
			animation.now = animation.to;
		}
		else
		{
			ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
			animation.now = computeNextFloat (animation.from, animation.to, ease);
		}
		
		animation.firstElement.style.opacity = animation.now;
	}catch(error) {
		handle_error(error);
	}
}

// The showPrefs function is called when the preferences button is clicked.  It prepares
// the widget to show the preferences, and then flips them.  More on this can be found in
// the Dashboard documentation.

function showPrefs()
{
	var front = document.getElementById("front");		// first, you need to get the front
	var back = document.getElementById("back");			// and back layers
	
	if(window.widget)									// this freezes the currently visible
		widget.prepareForTransition("ToBack");			// layer
	
	front.style.display="none";							// the preferences layer is made
	back.style.display="block";							// visible and the picture is hidden
				
	if(window.widget)									// the flip transition is run, with the
		setTimeout ('widget.performTransition();', 0);	// frozen side on the front and the
														// preferences on the back

	//document.prefButtonHighlight.style.display='none';
}

// When the "Done" button is clicked in the preferences, this function is called. It swaps
// the preference layer out with the picture and frame.

function hidePrefs()
{
	
	document.getElementById("doneButton").src = "Images/done.png";  // restore the regular
																	// "Done" button

	var front = document.getElementById("front");		// again, you need to obtain the front
	var back = document.getElementById("back");			// and back layers
	
	if (window.widget)									// then freeze the visible layer (as seen
		widget.prepareForTransition("ToFront");			// by the user
	
	front.style.display="block";						// hide the preferences layer and shot the 
	back.style.display="none";							// main picture layer
	
	if (window.widget)									// and run the flip transition; note that since
		setTimeout ('widget.performTransition();', 0);	// finishEdit() was used to freeze the UI, this 
}		

// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

function enterflipblack(event)
{
	document.getElementById('fliprollieblack').style.display = 'block';
}

function exitflipblack(event)
{
	document.getElementById('fliprollieblack').style.display = 'none';
}